#/bin/bash
#PBS -l nodes=1:ppn=1,walltime=00:15:00,mem=4gb
#PBS -A PAS0654
#PBS -e /fs/scratch/PAS0654/osu0673/PhasedArraySim/err_out_logs
#PBS -o /fs/scratch/PAS0654/osu0673/PhasedArraySim/err_out_logs

if [ "$INPUTFILE" = "" ]
then
   echo "INPUTFILE environmental variable must be set" 1>&2
   exit 1
fi

if [ "$RUN_NO" = "" ]
then
   echo "RUN_NO environmental variable must be set" 1>&2
   exit 1
fi

if [ "$RUN_DIR" = "" ]
then
   echo "RUN_DIR environmental variable must be set" 1>&2
   exit 1
fi

if [ "$OUTPUT_DIR" = "" ]
then
   echo "OUTPUT_DIR environmental variable must be set" 1>&2
   exit 1
fi

eval 'source /users/PAS0654/osu0673/PhasedArraySim/pasim_bashrc.sh'

cd $RUN_DIR

./AraSim $INPUTFILE $RUN_NO $TMPDIR

pbsdcp $TMPDIR/'*' $OUTPUT_DIR
