#!/bin/bash

AraSimDir='/users/PAS0654/osu0673/PhasedArraySim/AraSimGithub'
SetUpFile='/users/PAS0654/osu0673/PhasedArraySim/AraSimGithub/SETUP/setup_kotera.txt'
OutputDir='/fs/scratch/PAS0654/osu0673/PhasedArraySim/sim_output'

export AraSimDir
export SetUpFile
export OutputDir

echo ""
echo "--------------------------------------------"
echo "----- Preparing to batch submit AraSim "
echo "----- "
echo "----- AraSimDir: " $AraSimDir
echo "----- SetUpFile: " $SetUpFile
echo "----- outputDir: " $OutputDir
echo "----- "
echo "--------------------------------------------"
echo ""

read -p "Press Enter to run! " RUNNOW

#this is the bit that actually executes the running
#the AraRoot file names will be indexed by the "i" variable, so 
#"for i in `seq 1 100 `" will generate 100 AraOut.root files, named AraOut.1.root, AraOut.2.root .... AraOut.100.root
#if you want to generate files 101-200, change this to "for i in `seq 101 2001"

for i in `seq 1 2`;
do
	echo $i
	qsub run_arasim_job.sh -v INPUTFILE=$SetUpFile,RUN_NO=$i,RUN_DIR=$AraSimDir,OUTPUT_DIR=$OutputDir
done

